#include <stdio.h>
#include <stdlib.h>
#include <math.h>

typedef struct {
    long long x, y;
} Point;


int cross_product(Point a, Point b, Point c) {
    return (b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x);
}


int compare(const void *a, const void *b) {
    Point *p1 = (Point*)a, *p2 = (Point*)b;
    if (p1->x == p2->x) return p1->y - p2->y;
    return p1->x - p2->x;
}


int convex_hull(Point *points, int n, Point *hull) {
    qsort(points, n, sizeof(Point), compare);

    int m = 0;

    
    for (int i = 0; i < n; i++) {
        while (m >= 2 && cross_product(hull[m-2], hull[m-1], points[i]) <= 0)
            m--;
        hull[m++] = points[i];
    }

    
    int t = m + 1;
    for (int i = n - 2; i >= 0; i--) {
        while (m >= t && cross_product(hull[m-2], hull[m-1], points[i]) <= 0)
            m--;
        hull[m++] = points[i];
    }

    return m - 1; 
}


long long polygon_area(Point *hull, int n) {
    long long area = 0;
    for (int i = 0; i < n; i++) {
        int next = (i + 1) % n;
        area += hull[i].x * hull[next].y - hull[i].y * hull[next].x;
    }
    return abs(area) / 2;
}

int main() {
    int n;
    scanf("%d", &n);

    Point points[n];
    for (int i = 0; i < n; i++) {
        scanf("%lld %lld", &points[i].x, &points[i].y);
    }

   
    Point hull[n];
    
    
    int hull_size = convex_hull(points, n, hull);
    
    
    long long area = polygon_area(hull, hull_size);
    
    printf("%lld\n", area);
    
    return 0;
}